---------------------------------------------------------------------------------------------------------
-- BEGIN HEADER
---------------------------------------------------------------------------------------------------------
-- DDL for Alkindi Schema Model Version 0.5
-- DDL to create packages and procedures
-- Myles Weber, Appian Corporation
-- Weber@AppianCorp.com
-- Date Created: September 12, 2000 MSW
-- Date Updated: October 5, 2000 MSW
---------------------------------------------------------------------------------------------------------
-- END HEADER
---------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------
-- BEGIN CHANGE LOG SINCE VERSION 0.4
---------------------------------------------------------------------------------------------------------
-- WHO WHEN   WHAT
-- MSW 092700 Added Change Log
-- MSW 092700 Added Header Comments
-- AHW 092700 Changed error codes for all stored procedures
-- MSW 092700 Added 'SHOW ERRORS' statement after each package creation
-- MSW 100300 Renamed REL_PRODUCT_CLUSTER_USER with USER_PRODUCT_CLUSTER_STAT (Table name changed)
-- MSW 100300 Renamed NUM_MOVIES_SEEN to TOTAL_PROD_SEEN (Column name changed)
-- MSW 100300 Renamed CALC_E to FRACTION_OF_PC_SEEN (Column name changed) CHECK WITH BWL
-- MSW 100300 Renamed CALC_R to AVG_PROD_EVAL (Column name changed)
-- MSW 100300 Renamed sp_SEL_NMSER_CALCS to SP_SEL_USER_PC_STAT
-- MSW 100300 Renamed TOTAL_OF_USER_SEEN_PROD to TOTAL_USER_SEEN
-- MSW 100300 Renamed FRACTION_OF_UC_SEEN_PROD to FRACTION_OF_UC_SEEN
-- MSW 100300 Renamed PRODUCT_CLUSTER_ACTIVE to PRODUCT_CLUSTER_ACTIVE_IND
-- MSW 100300 Renamed FRACTION_OF_UC_ASK_PROD to FRACTION_OF_UC_EVAL
-- MSW 100400 Renamed USER_CLUSTER_PRODUCT_STAT to PRODUCT_USER_CLUSTER_STAT
-- MSW 100400 Renamed FRACTION_OF_PC_SEEN to FRACTION_OF_EVAL_SEEN
-- MSW 100400 Added pkg_ALKINDI_RECOMMENDATION.sp_SEL_USER_DATA
-- MSW 100400 Added pkg_ALKINDI_RECOMMENDATION.sp_SEL_ALKINDEX_DATA
-- MSW 100400 Added pkg_ALKINDI_RECOMMENDATION.sp_SEL_NEW_PROD_DATA_BY_PC1
-- MSW 100400 Added pkg_ALKINDI_RECOMMENDATION.sp_SEL_NEW_PROD_DATA_BY_PC2
-- MSW 100500 Added pkg_ALKINDI_RECOMMENDATION.sp_SEL_OLD_PROD_DATA_BY_PC1
-- MSW 100500 Added pkg_ALKINDI_RECOMMENDATION.sp_SEL_OLD_PROD_DATA_BY_PC2
-- MSW 100600 Moved sp_INS_ReCalcStats to its own file, ddl_pkg_calc5.sql
-- MSW 100700 Moved pkg_ALKINDI_RECOMMENDATION.sp_SEL_USER_DATA to pkg_ALKINDI_EVALUATION.sp_SEL_USER_DATA
-- MSW 100700 Moved pkg_ALKINDI_RECOMMENDATION.sp_SEL_ALKINDEX_DATA to pkg_ALKINDI_EVALUATION.sp_SEL_ALKINDEX_DATA
-- MSW 100700 Moved pkg_ALKINDI_RECOMMENDATION.sp_SEL_NEW_PROD_DATA_BY_PC1 to pkg_ALKINDI_EVALUATION.sp_SEL_NEW_PROD_DATA_BY_PC1
-- MSW 100700 Moved pkg_ALKINDI_RECOMMENDATION.sp_SEL_NEW_PROD_DATA_BY_PC2 to pkg_ALKINDI_EVALUATION.sp_SEL_NEW_PROD_DATA_BY_PC2
-- MSW 100700 Moved pkg_ALKINDI_RECOMMENDATION.sp_SEL_OLD_PROD_DATA_BY_PC1 to pkg_ALKINDI_EVALUATION.sp_SEL_OLD_PROD_DATA_BY_PC1
-- MSW 100700 Moved pkg_ALKINDI_RECOMMENDATION.sp_SEL_OLD_PROD_DATA_BY_PC2 to pkg_ALKINDI_EVALUATION.sp_SEL_OLD_PROD_DATA_BY_PC2

---------------------------------------------------------------------------------------------------------
-- END CHANGE LOG SINCE VERSION 0.4
---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE PACKAGE pkg_ALKINDI_RECOMMENDATION
AS
  TYPE RECOMMENDATION_cursor_type is REF CURSOR;

  PROCEDURE sp_SEL_Prod_By_UserScore(							-- BK092400
	i_USER_ID				IN		EVALUATION.USER_ID%TYPE,
	i_PRODUCT_CLUSTER_ID		IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_M_Calcs(									-- BK092400
	i_USER_ID				IN		EVALUATION.USER_ID%TYPE,
	i_PRODUCT_CLUSTER_ID		IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,	-- MSW 092500, Changed from USER_CLUSTER_ID
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_USER_PC_STAT(								-- BK092400
	i_USER_ID				IN		EVALUATION.USER_ID%TYPE,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_CountProd_In_PC(
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_CountSeen_In_UC(
	i_USER_ID				IN		EVALUATION.USER_ID%TYPE,
	i_PRODUCT_ID			IN		EVALUATION.PRODUCT_ID%TYPE,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_All_PC_Status(
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_AVG_PRODEVALS_BY_USER(
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);
  
  PROCEDURE sp_SEL_AVG_PRODEVALS_BY_PROD(
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_ALKINDEX_DATA(
	i_USER_ID				IN		USER_ID.USER_ID%TYPE,
	i_a					IN		NUMBER,
	i_b					IN		NUMBER,
	i_PRODUCT_ID			IN		EVALUATION.PRODUCT_ID%TYPE,
	o_us					OUT		USER_STAT.TOTAL_PROD_SEEN%TYPE,
	o_Bi					OUT		PRODUCT_STAT.AVG_USER_EVAL%TYPE,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

END pkg_ALKINDI_RECOMMENDATION;
/

-- ==========================================================================================

SHOW ERRORS

-- ==========================================================================================

CREATE OR REPLACE PACKAGE BODY pkg_ALKINDI_RECOMMENDATION
AS
-- MSW 092500
-- Sp to retrieve a list of products from a user cluster that is associated with a 
-- specified user and product cluster. The results are sorted in descending order of scores.

  PROCEDURE sp_SEL_Prod_By_UserScore(
	i_USER_ID				IN		EVALUATION.USER_ID%TYPE,
	i_PRODUCT_CLUSTER_ID		IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)

   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_RECOMMENDATION_cursor_type FOR

	SELECT /*+ PUSH_SUBQ */ 
		 PRODUCT_ID 
	  FROM PRODUCT_USER_CLUSTER_STAT
	 WHERE USER_CLUSTER_ID =
     (SELECT MIN(USER_CLUSTER_ID)
	  FROM REL_USER_CLUSTER
	 WHERE USER_ID = i_USER_ID
	   AND USER_CLUSTER_ID IN
     (SELECT USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID))
    ORDER BY FRACTION_OF_UC_SEEN DESC;

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6554;
		CLOSE o_RECOMMENDATION_cursor_type;
 END sp_SEL_Prod_By_UserScore;

-- ==========================================================================================

-- BK092400 - Selects M Calculation for Recommendation Manager

  PROCEDURE sp_SEL_M_CALCS(
	i_USER_ID				IN		EVALUATION.USER_ID%TYPE,
	i_PRODUCT_CLUSTER_ID		IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)

   IS BEGIN
	o_ERROR_CODE	:= 0;
	OPEN o_RECOMMENDATION_cursor_type FOR

	SELECT CALC_M1, CALC_M2, CALC_M3, CALC_M4
	  FROM USER_CLUSTER_MEAN_DISTANCE
	 WHERE USER_ID = i_USER_ID
	   AND USER_CLUSTER_ID IN
     (SELECT USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID);

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6555;
		CLOSE o_RECOMMENDATION_cursor_type;
 END sp_SEL_M_CALCS;

-- ==========================================================================================

-- BK092400 - Select Number of Movies Seen, E and R Calculation for a given user.  Used by Recommendation Manager

  PROCEDURE sp_SEL_USER_PC_STAT(
	i_USER_ID				IN		EVALUATION.USER_ID%TYPE,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_RECOMMENDATION_cursor_type FOR

	SELECT USER_PRODUCT_CLUSTER_STAT.PRODUCT_CLUSTER_ID
	     , USER_PRODUCT_CLUSTER_STAT.TOTAL_PROD_SEEN
	     , USER_PRODUCT_CLUSTER_STAT.FRACTION_OF_EVAL_SEEN
	     , USER_PRODUCT_CLUSTER_STAT.AVG_PROD_EVAL
	  FROM USER_PRODUCT_CLUSTER_STAT
	     , PRODUCT_CLUSTER
	 WHERE USER_PRODUCT_CLUSTER_STAT.USER_ID = i_USER_ID
         AND USER_PRODUCT_CLUSTER_STAT.PRODUCT_CLUSTER_ID = PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID
         AND PRODUCT_CLUSTER.PRODUCT_CLUSTER_ACTIVE_IND = 1;
   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6556;
		CLOSE o_RECOMMENDATION_cursor_type;
 END sp_SEL_USER_PC_STAT;

-- ==========================================================================================

-- BK092400 - Selects Number of Products in each Product Cluster
  PROCEDURE sp_SEL_CountProd_In_PC(
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;
	OPEN o_RECOMMENDATION_cursor_type FOR

	SELECT A.PRODUCT_CLUSTER_ID, COUNT(A.PRODUCT_ID)
	  FROM REL_PRODUCT_CLUSTER A, PRODUCT_CLUSTER B
       WHERE A.PRODUCT_CLUSTER_ID = B.PRODUCT_CLUSTER_ID
         AND B.PRODUCT_CLUSTER_ACTIVE_IND = 1				-- BK 092400 - Active Product Clusters Only
	 GROUP BY A.PRODUCT_CLUSTER_ID;
   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6557;
		CLOSE o_RECOMMENDATION_cursor_type;
 END sp_SEL_CountProd_In_PC;

-- ==========================================================================================

  PROCEDURE sp_SEL_CountSeen_In_UC(							-- MSW 092500, for BWL
	i_USER_ID				IN		EVALUATION.USER_ID%TYPE,
	i_PRODUCT_ID			IN		EVALUATION.PRODUCT_ID%TYPE,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)

   IS BEGIN
	o_ERROR_CODE	:= 0;
	OPEN o_RECOMMENDATION_cursor_type FOR

	SELECT PRODUCT_CLUSTER_ID
	     , TOTAL_USER_SEEN
	     , PROD_EVAL_MEAN_BY_UC
	  FROM PRODUCT_USER_CLUSTER_STAT
	     , USER_CLUSTER
       WHERE PRODUCT_ID = i_PRODUCT_ID
	   AND PRODUCT_USER_CLUSTER_STAT.USER_CLUSTER_ID IN 
     (SELECT USER_CLUSTER_ID 
	  FROM REL_USER_CLUSTER
	 WHERE USER_ID = i_USER_ID)
	   AND USER_CLUSTER.USER_CLUSTER_ID = PRODUCT_USER_CLUSTER_STAT.USER_CLUSTER_ID;

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6558;
		CLOSE o_RECOMMENDATION_cursor_type;
 END sp_SEL_CountSeen_In_UC;

-- ==========================================================================================

  PROCEDURE sp_SEL_All_PC_Status(
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)

  IS BEGIN
	o_ERROR_CODE	:= 0;
	OPEN o_RECOMMENDATION_cursor_type FOR

	SELECT PRODUCT_CLUSTER_ID
	     , PRODUCT_CLUSTER_ACTIVE_IND
	  FROM PRODUCT_CLUSTER;
  EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6559;
		CLOSE o_RECOMMENDATION_cursor_type;
  END sp_SEL_All_PC_Status;

-- ==========================================================================================

  PROCEDURE sp_SEL_AVG_PRODEVALS_BY_USER(
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)

  IS BEGIN 
	o_ERROR_CODE := 0; 

	OPEN o_RECOMMENDATION_cursor_type FOR

	SELECT EVALUATION.USER_ID
	     , AVG(EVALUATION_SCALE_ID)
	  FROM EVALUATION
	 WHERE EVALUATION_SCALE_ID <> -1
    GROUP BY USER_ID;

  EXCEPTION
  	WHEN OTHERS THEN
      o_ERROR_CODE  := 6568;
      CLOSE o_RECOMMENDATION_cursor_type;
  END sp_SEL_AVG_PRODEVALS_BY_USER; 

-- ==========================================================================================
  
  PROCEDURE sp_SEL_AVG_PRODEVALS_BY_PROD(
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)
  IS BEGIN 
	o_ERROR_CODE := 0; 

	OPEN o_RECOMMENDATION_cursor_type FOR

	SELECT EVALUATION.PRODUCT_ID
	     , AVG(EVALUATION_SCALE_ID)
	  FROM EVALUATION
	 WHERE EVALUATION_SCALE_ID <> -1
    GROUP BY PRODUCT_ID;

  EXCEPTION
	WHEN OTHERS THEN
      o_ERROR_CODE  := 6569;
      CLOSE o_RECOMMENDATION_cursor_type;
  END sp_SEL_AVG_PRODEVALS_BY_PROD; 

-- ==========================================================================================

-- WIP MSW 100300

  PROCEDURE sp_SEL_ALKINDEX_DATA(
	i_USER_ID				IN		USER_ID.USER_ID%TYPE,
	i_a					IN		NUMBER,
	i_b					IN		NUMBER,
	i_PRODUCT_ID			IN		EVALUATION.PRODUCT_ID%TYPE,
	o_us					OUT		USER_STAT.TOTAL_PROD_SEEN%TYPE,
	o_Bi					OUT		PRODUCT_STAT.AVG_USER_EVAL%TYPE,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)
  IS 
c_UC_ID RECOMMENDATION_cursor_type;
  BEGIN 
	o_ERROR_CODE := 0; 

--OPEN c_UC_ID FOR SELECT USER_CLUSTER_ID FROM USER_CLUSTER_MEAN_DISTANCE WHERE USER_ID = i_USER_ID;

--FOR DATA  

-- Bi
	SELECT AVG_USER_EVAL INTO o_Bi
	  FROM PRODUCT_STAT
	 WHERE PRODUCT_ID = i_PRODUCT_ID;

-- us
	SELECT TOTAL_PROD_SEEN INTO o_us
	  FROM USER_STAT
	 WHERE USER_ID = i_USER_ID;

--OPEN o_RECOMMENDATION_cursor_type FOR
--	SELECT PRODUCT_CLUSTER_ID
--	  FROM USER_CLUSTER
--	 WHERE USER_CLUSTER_ID IN
--     (SELECT USER_CLUSTER_ID
--	  FROM REL_USER_CLUSTER
--	 WHERE USER_ID = 1);

OPEN o_RECOMMENDATION_cursor_type FOR
	SELECT PRODUCT_CLUSTER_ID, AVG(EVALUATION_SCALE_ID)
	  FROM EVALUATION, REL_PRODUCT_CLUSTER
	 WHERE USER_ID IN
     (SELECT USER_ID
	  FROM REL_USER_CLUSTER
	 WHERE USER_CLUSTER_ID IN
     (SELECT USER_CLUSTER_ID
	  FROM REL_USER_CLUSTER
	 WHERE USER_ID = 1)
	   AND USER_ID IN
     (SELECT USER_ID
	  FROM USER_CLUSTER_MEAN_DISTANCE
	 WHERE USER_CLUSTER_ID IN
     (SELECT USER_CLUSTER_ID
	  FROM REL_USER_CLUSTER
	 WHERE USER_ID = 1
	   AND CALC_M2 > CALC_M2 - .9
	   AND CALC_M2 < CALC_M2 + .9)))
	   AND REL_PRODUCT_CLUSTER.PRODUCT_ID = EVALUATION.PRODUCT_ID
	   AND EVALUATION.PRODUCT_ID=1
	GROUP BY PRODUCT_CLUSTER_ID;



--	SELECT USER_CLUSTER_ID, USER_ID
--	  FROM USER_CLUSTER_MEAN_DISTANCE
--	 WHERE USER_CLUSTER_ID IN
--   (SELECT USER_CLUSTER_ID
--	ROM USER_CLUSTER_MEAN_DISTANCE
--	WHERE USER_ID = 1)
--	   AND CALC_M2 > (SELECT CALC_M2 - .9 FROM USER_CLUSTER_MEAN_DISTANCE WHERE
--	   AND CALC_M2 < CALC_M2 + .9


--	SELECT USER_CLUSTER_ID, USER_ID FROM USER_CLUSTER_MEAN_DISTANCE WHERE

  EXCEPTION
	WHEN OTHERS THEN
      o_ERROR_CODE  := -1;
      CLOSE o_RECOMMENDATION_cursor_type;
  END sp_SEL_ALKINDEX_DATA;

-- ==========================================================================================


END pkg_ALKINDI_RECOMMENDATION;
/

SHOW ERRORS
